(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     20587,        484]
NotebookOptionsPosition[     20265,        468]
NotebookOutlinePosition[     20609,        483]
CellTagsIndexPosition[     20566,        480]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "t", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "t", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "t"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "t"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"t", 
        RowBox[{"{", " ", 
         RowBox[{
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", "Red", "}"}]}]}], "]"}], ",", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", " ", 
         RowBox[{
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}], "+", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"Cos", "[", "f", "]"}], 
            RowBox[{"Sin", "[", "t", "]"}]}], ",", 
           RowBox[{
            RowBox[{"Sin", "[", "f", "]"}], 
            RowBox[{"Sin", "[", "t", "]"}]}], ",", 
           RowBox[{"Cos", "[", "t", "]"}]}], "}"}], "/", "10"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "Pi"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"t", 
         RowBox[{"{", "  ", 
          RowBox[{
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", "0"}], "}"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "t"}], ")"}], 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Dashed", ",", "Black"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"t", 
        RowBox[{"{", "  ", 
         RowBox[{
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", "0"}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", "Blue", "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"t", 
         RowBox[{"{", "  ", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "t"}], ")"}], 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Dashed", ",", "Black"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"\[Rho]", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], 
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "/", "3"}]}], ",", " ", 
         RowBox[{"\[Rho]", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], 
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "/", "3"}]}], ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", "Black", "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"\[Rho]", " ", "t", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], 
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "/", "3"}]}], ",", " ", 
         RowBox[{"\[Rho]", " ", "t", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"f", " ", "\[CurlyPhi]"}], "]"}], 
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "/", "3"}]}], ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Blue", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", " ", 
         RowBox[{
          RowBox[{"t", " ", "\[Rho]", "  ", 
           RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], 
           RowBox[{"Sin", "[", 
            RowBox[{"f", " ", "\[Theta]"}], "]"}]}], ",", 
          RowBox[{"t", " ", "\[Rho]", " ", 
           RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], 
           RowBox[{"Sin", "[", 
            RowBox[{"f", " ", "\[Theta]"}], "]"}]}], ",", 
          RowBox[{"t", " ", "\[Rho]", "  ", 
           RowBox[{"Cos", "[", 
            RowBox[{"f", " ", "\[Theta]"}], "]"}]}]}], "}"}], "/", "3"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Rho]", "  ", 
           RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}], 
           RowBox[{"Sin", "[", 
            RowBox[{"f", " ", "\[Theta]"}], "]"}]}], ",", 
          RowBox[{"\[Rho]", " ", 
           RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}], 
           RowBox[{"Sin", "[", 
            RowBox[{"f", " ", "\[Theta]"}], "]"}]}], ",", " ", 
          RowBox[{"\[Rho]", "  ", 
           RowBox[{"Cos", "[", 
            RowBox[{"f", " ", "\[Theta]"}], "]"}]}]}], "}"}], "/", "3"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", " ", "Black", "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "8"}], ",", "8"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"AxesOrigin", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", " ", 
    RowBox[{"\[Rho]", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", " ", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.57202315256959*^9, 3.5720231998612947`*^9}, {
   3.572023232148142*^9, 3.572023269934303*^9}, {3.572023302431162*^9, 
   3.572023340625346*^9}, {3.572023371537114*^9, 3.5720233989646826`*^9}, {
   3.5720234556219234`*^9, 3.5720235393097105`*^9}, {3.572023576456835*^9, 
   3.5720236044194345`*^9}, {3.5720236378933487`*^9, 3.572023646110819*^9}, {
   3.5720237224571857`*^9, 3.572023726076393*^9}, {3.5720237791304274`*^9, 
   3.5720238304153605`*^9}, {3.57202389527207*^9, 3.5720239172153254`*^9}, {
   3.5720239733365355`*^9, 3.5720239837181287`*^9}, 3.5720240202482185`*^9, {
   3.5720240720521812`*^9, 3.5720241589301505`*^9}, {3.572024195682253*^9, 
   3.5720242043547487`*^9}, {3.572024252570506*^9, 3.572024279804064*^9}, {
   3.572024368941162*^9, 3.5720243697922115`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Theta]$$ = 
    1.4930191026385522`, $CellContext`\[Rho]$$ = 
    7.910625457763672, $CellContext`\[CurlyPhi]$$ = 0.311788234398362, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Rho]$$], 0, 8}, {
      Hold[$CellContext`\[CurlyPhi]$$], 0, 2 Pi}, {
      Hold[$CellContext`\[Theta]$$], 0, Pi}}, Typeset`size$$ = {
    694., {311., 316.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Rho]$25939$$ = 
    0, $CellContext`\[CurlyPhi]$25940$$ = 0, $CellContext`\[Theta]$25941$$ = 
    0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`\[Theta]$$ = 0, $CellContext`\[Rho]$$ = 
        0, $CellContext`\[CurlyPhi]$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`\[Rho]$$, $CellContext`\[Rho]$25939$$, 0], 
        Hold[$CellContext`\[CurlyPhi]$$, $CellContext`\[CurlyPhi]$25940$$, 0], 
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$25941$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[{
         ParametricPlot3D[{$CellContext`t, 0, 0}, {$CellContext`t, 0, 10}, 
          PlotStyle -> Thick], 
         ParametricPlot3D[{$CellContext`t, 0, 0}, {$CellContext`t, -10, 0}, 
          PlotStyle -> {Thick, Dashed}], 
         ParametricPlot3D[{0, $CellContext`t, 0}, {$CellContext`t, 0, 10}, 
          PlotStyle -> Thick], 
         ParametricPlot3D[{0, $CellContext`t, 0}, {$CellContext`t, -10, 0}, 
          PlotStyle -> {Thick, Dashed}], 
         ParametricPlot3D[{0, 0, $CellContext`t}, {$CellContext`t, 0, 10}, 
          PlotStyle -> Thick], 
         ParametricPlot3D[{0, 0, $CellContext`t}, {$CellContext`t, -10, 0}, 
          PlotStyle -> {Thick, Dashed}]}, 
        ParametricPlot3D[$CellContext`t {$CellContext`\[Rho]$$ 
           Cos[$CellContext`\[CurlyPhi]$$] 
           Sin[$CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
           Sin[$CellContext`\[CurlyPhi]$$] 
           Sin[$CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
           Cos[$CellContext`\[Theta]$$]}, {$CellContext`t, 0, 1}, 
         PlotStyle -> {Red}], 
        ParametricPlot3D[{$CellContext`\[Rho]$$ 
           Cos[$CellContext`\[CurlyPhi]$$] 
           Sin[$CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
           Sin[$CellContext`\[CurlyPhi]$$] 
           Sin[$CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
           Cos[$CellContext`\[Theta]$$]} + {
           Cos[$CellContext`f] Sin[$CellContext`t], Sin[$CellContext`f] 
            Sin[$CellContext`t], 
            Cos[$CellContext`t]}/10, {$CellContext`f, 0, 2 
          Pi}, {$CellContext`t, 0, Pi}, PlotStyle -> Black], 
        ParametricPlot3D[$CellContext`t {$CellContext`\[Rho]$$ 
            Cos[$CellContext`\[CurlyPhi]$$] 
            Sin[$CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
            Sin[$CellContext`\[CurlyPhi]$$] Sin[$CellContext`\[Theta]$$], 
            0} + (1 - $CellContext`t) {$CellContext`\[Rho]$$ 
            Cos[$CellContext`\[CurlyPhi]$$] 
            Sin[$CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
            Sin[$CellContext`\[CurlyPhi]$$] 
            Sin[$CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
            Cos[$CellContext`\[Theta]$$]}, {$CellContext`t, 0, 1}, 
         PlotStyle -> {Dashed, Black}], 
        ParametricPlot3D[$CellContext`t {$CellContext`\[Rho]$$ 
           Cos[$CellContext`\[CurlyPhi]$$] 
           Sin[$CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
           Sin[$CellContext`\[CurlyPhi]$$] Sin[$CellContext`\[Theta]$$], 
           0}, {$CellContext`t, 0, 1}, PlotStyle -> {Blue}], 
        ParametricPlot3D[$CellContext`t {
           0, 0, $CellContext`\[Rho]$$ Cos[$CellContext`\[Theta]$$]} + (
           1 - $CellContext`t) {$CellContext`\[Rho]$$ 
            Cos[$CellContext`\[CurlyPhi]$$] 
            Sin[$CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
            Sin[$CellContext`\[CurlyPhi]$$] 
            Sin[$CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
            Cos[$CellContext`\[Theta]$$]}, {$CellContext`t, 0, 1}, 
         PlotStyle -> {Dashed, Black}], 
        ParametricPlot3D[{$CellContext`\[Rho]$$ 
          Cos[$CellContext`f $CellContext`\[CurlyPhi]$$] (
           Sin[$CellContext`\[Theta]$$]/3), $CellContext`\[Rho]$$ 
          Sin[$CellContext`f $CellContext`\[CurlyPhi]$$] (
           Sin[$CellContext`\[Theta]$$]/3), 0}, {$CellContext`f, 0, 1}, 
         PlotStyle -> {Black}], 
        ParametricPlot3D[{$CellContext`\[Rho]$$ $CellContext`t 
          Cos[$CellContext`f $CellContext`\[CurlyPhi]$$] (
           Sin[$CellContext`\[Theta]$$]/
           3), $CellContext`\[Rho]$$ $CellContext`t 
          Sin[$CellContext`f $CellContext`\[CurlyPhi]$$] (
           Sin[$CellContext`\[Theta]$$]/3), 0}, {$CellContext`t, 0, 
          1}, {$CellContext`f, 0, 1}, Mesh -> None, PlotStyle -> {Blue, 
           Opacity[0.5]}], 
        ParametricPlot3D[{$CellContext`t $CellContext`\[Rho]$$ 
           Cos[$CellContext`\[CurlyPhi]$$] 
           Sin[$CellContext`f $CellContext`\[Theta]$$], $CellContext`t \
$CellContext`\[Rho]$$ Sin[$CellContext`\[CurlyPhi]$$] 
           Sin[$CellContext`f $CellContext`\[Theta]$$], $CellContext`t \
$CellContext`\[Rho]$$ Cos[$CellContext`f $CellContext`\[Theta]$$]}/
         3, {$CellContext`t, 0, 1}, {$CellContext`f, 0, 1}, Mesh -> None, 
         PlotStyle -> {Red, 
           Opacity[0.5]}], 
        ParametricPlot3D[{$CellContext`\[Rho]$$ 
           Cos[$CellContext`\[CurlyPhi]$$] 
           Sin[$CellContext`f $CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
           Sin[$CellContext`\[CurlyPhi]$$] 
           Sin[$CellContext`f $CellContext`\[Theta]$$], $CellContext`\[Rho]$$ 
           Cos[$CellContext`f $CellContext`\[Theta]$$]}/
         3, {$CellContext`f, 0, 1}, Mesh -> None, PlotStyle -> {Black}], 
        PlotRange -> {{-8, 8}, {-8, 8}, {-8, 8}}, Boxed -> False, Axes -> 
        False, AxesOrigin -> {0, 0}], 
      "Specifications" :> {{$CellContext`\[Rho]$$, 0, 
         8}, {$CellContext`\[CurlyPhi]$$, 0, 2 Pi}, {$CellContext`\[Theta]$$, 
         0, Pi}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{743., {384., 389.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.572023173076763*^9, 3.5720232707833514`*^9, 3.5720233118447*^9, 
   3.5720234045750036`*^9, {3.5720234691146955`*^9, 3.5720234937891064`*^9}, 
   3.5720235405797825`*^9, 3.5720236048594594`*^9, 3.5720236466628504`*^9, 
   3.572023739038134*^9, 3.5720237843687267`*^9, 3.572023830708377*^9, 
   3.572023917767357*^9, 3.5720239844111686`*^9, 3.572024021206273*^9, 
   3.572024078547553*^9, 3.57202415944418*^9, 3.5720242060988483`*^9, 
   3.572024280479103*^9}]
}, Open  ]]
},
WindowSize->{1904, 945},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 12233, 307, 232, "Input"],
Cell[12815, 331, 7434, 134, 790, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
